import type { IncomingSocketEvent, OutgoingSocketEvent } from "./events";
import type { Mode } from "../BaseConversation";
import type { ConversationConfigOverrideAgentLanguage as Language } from "@elevenlabs/types/generated/types/asyncapi-types";
import type { DisconnectionDetails } from "@elevenlabs/types";
export type { DisconnectionDetails, ConversationConfigOverrideAgentLanguage as Language, } from "@elevenlabs/types";
export type DelayConfig = {
    default: number;
    android?: number;
    ios?: number;
};
export type FormatConfig = {
    format: "pcm" | "ulaw";
    sampleRate: number;
    outputDeviceId?: string;
};
export type OnDisconnectCallback = (details: DisconnectionDetails) => void;
export type OnMessageCallback = (event: IncomingSocketEvent) => void;
export type BaseSessionConfig = {
    origin?: string;
    authorization?: string;
    livekitUrl?: string;
    overrides?: {
        agent?: {
            prompt?: {
                prompt?: string;
            };
            firstMessage?: string;
            language?: Language;
        };
        tts?: {
            voiceId?: string;
        };
        conversation?: {
            textOnly?: boolean;
        };
        client?: {
            source?: string;
            version?: string;
        };
    };
    customLlmExtraBody?: unknown;
    dynamicVariables?: Record<string, string | number | boolean>;
    useWakeLock?: boolean;
    connectionDelay?: DelayConfig;
    textOnly?: boolean;
    userId?: string;
};
export type ConnectionType = "websocket" | "webrtc";
export type PublicSessionConfig = BaseSessionConfig & {
    agentId: string;
    connectionType: ConnectionType;
    signedUrl?: never;
    conversationToken?: never;
};
export type PrivateWebSocketSessionConfig = BaseSessionConfig & {
    signedUrl: string;
    connectionType?: "websocket";
    agentId?: never;
    conversationToken?: never;
};
export type PrivateWebRTCSessionConfig = BaseSessionConfig & {
    conversationToken: string;
    connectionType?: "webrtc";
    agentId?: never;
    signedUrl?: never;
};
export type SessionConfig = PublicSessionConfig | PrivateWebSocketSessionConfig | PrivateWebRTCSessionConfig;
export declare abstract class BaseConnection {
    abstract readonly conversationId: string;
    abstract readonly inputFormat: FormatConfig;
    abstract readonly outputFormat: FormatConfig;
    protected queue: IncomingSocketEvent[];
    protected disconnectionDetails: DisconnectionDetails | null;
    protected onDisconnectCallback: OnDisconnectCallback | null;
    protected onMessageCallback: OnMessageCallback | null;
    protected onModeChangeCallback: ((mode: Mode) => void) | null;
    protected onDebug?: (info: unknown) => void;
    constructor(config?: {
        onDebug?: (info: unknown) => void;
    });
    protected debug(info: unknown): void;
    abstract close(): void;
    abstract sendMessage(message: OutgoingSocketEvent): void;
    abstract setMicMuted(isMuted: boolean): Promise<void>;
    onMessage(callback: OnMessageCallback): void;
    onDisconnect(callback: OnDisconnectCallback): void;
    onModeChange(callback: (mode: Mode) => void): void;
    protected updateMode(mode: Mode): void;
    protected disconnect(details: DisconnectionDetails): void;
    protected handleMessage(parsedEvent: IncomingSocketEvent): void;
}
export declare function parseFormat(format: string): FormatConfig;
